/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.betterend.blocks.basis.EndLanternBlock;
import org.betterx.betterend.client.models.Patterns;
import org.jetbrains.annotations.Nullable;

public class BulbVineLanternBlock
extends EndLanternBlock
implements RenderLayerProvider,
BlockModelProvider,
BehaviourWood {
    private static final VoxelShape SHAPE_CEIL = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_FLOOR = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public BulbVineLanternBlock() {
        this(BehaviourBuilders.createMetal((MapColor)MapColor.f_283779_).m_60978_(1.0f).m_60953_(bs -> 15).m_60999_().m_60918_(SoundType.f_56762_));
    }

    public BulbVineLanternBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return (Boolean)state.m_61143_((Property)IS_FLOOR) != false ? SHAPE_FLOOR : SHAPE_CEIL;
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        HashMap textures = Maps.newHashMap();
        textures.put("%glow%", this.getGlowTexture());
        textures.put("%metal%", this.getMetalTexture(resourceLocation));
        Optional<String> pattern = (Boolean)blockState.m_61143_((Property)IS_FLOOR) != false ? Patterns.createJson(Patterns.BLOCK_BULB_LANTERN_FLOOR, textures) : Patterns.createJson(Patterns.BLOCK_BULB_LANTERN_CEIL, textures);
        return ModelsHelper.fromPattern(pattern);
    }

    protected String getMetalTexture(ResourceLocation blockId) {
        String name = blockId.m_135815_();
        name = name.substring(0, name.indexOf(95));
        return name + "_bulb_vine_lantern_metal";
    }

    protected String getGlowTexture() {
        return "bulb_vine_lantern_bulb";
    }
}

